#!/bin/bash


declare -A pids
gpu_index=0
best_end=3
current_time=$(date +"%Y-%m-%d-%H-%M-%S")


if [ $# -ne 2 ]; then
    echo "Usage: $0 'num' <reward_dir>"
    exit 1
fi

input=$1
if [ "$input" = "0" ]; then
    gpus=(0 1 2 3)
elif [ "$input" = "1" ]; then
    gpus=(4 5 6 7)
else
    echo "num error"
    exit 1
fi
gpu_count=${#gpus[@]}

reward_dir=$2
echo "Run with reward_dir=$reward_dir"

temp_log_dir="${reward_dir}/rl_temp_logs"
if [ ! -d "$temp_log_dir" ]; then
    mkdir -p "$temp_log_dir"
    echo "$temp_log_dir created"
else
    echo "$temp_log_dir already exists"
fi


for ((reward_index=0; reward_index<=best_end; reward_index++)); do
    gpu=${gpus[$gpu_index]}
    for seed in {1..5}; do
        CUDA_VISIBLE_DEVICES=$gpu python algos/IQL/main_iql.py \
            --seed $seed \
            --no_action_dim \
            --temperature 0.5 \
            --dropout_rate 0.1 \
            --reward_type best \
            --reward_index $reward_index \
            --reward_dir $reward_dir \
            --current_time $current_time \
            > "${temp_log_dir}/best_${reward_index}_seed${seed}.log" 2>&1 &
        echo "Started best $reward_index seed $seed on GPU $gpu"
        pids[$!]="best $reward_index $seed $gpu"
    done
    gpu_index=$(( (gpu_index + 1) % gpu_count ))
done


all_success=true

for pid in "${!pids[@]}"; do
    wait "$pid"
    status=$?
    IFS=' ' read -r type index seed gpu <<< "${pids[$pid]}"
    if [ $status -eq 0 ]; then
        echo "SUCCESS: [$type index=$index seed=$seed on GPU $gpu]"
    else
        echo "FAILED: [$type index=$index seed=$seed on GPU $gpu] with exit code $status"
        all_success=false
    fi
done

if $all_success; then
    echo "======All processes completed successfully======"
else
    echo "======Some processes failed. Please check the logs======"
fi
